<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Traveller extends Model
{
    /** @use HasFactory<\Database\Factories\TravellerFactory> */
    use HasFactory;

    protected $fillable = [
        'booking_id',
        'name',
        'phone',
        'date_of_birth',
        'type',
    ];

    protected $casts = [
        'date_of_birth' => 'datetime',
    ];

    public function booking()
    {
        return $this->belongsTo(Booking::class);
    }

    public function getFormattedDateOfBirthAttribute()
    {
        return $this->date_of_birth ? $this->date_of_birth->format('d M Y') : null;
    }

    public function getAgeAttribute()
    {
        return $this->date_of_birth ? $this->date_of_birth->age : null;
    }
}
